import os
import numpy

DATA_FOLDERS = ["6600_new", "6600_old", "1660"]
EXPECTED_LINE_ITEMS = 20
EXPECTED_RUNS_PER_TEST = 3

data = {}
categories = []

for data_folder in DATA_FOLDERS:
    for (dirpath, dirnames, filenames) in os.walk(data_folder):
        for file in filenames:
            if file.endswith(".csv"):
                f = open(data_folder + os.path.sep + file, 'r')
                content = f.read().split('\n')
                f.close()

                first_line = True
                frametimes = []
                for line in content:
                    if first_line:
                        first_line = False
                    else:
                        line_split = line.split(',')
                        if len(line_split) == EXPECTED_LINE_ITEMS:
                            frametime = 0.0
                            try:
                                frametime = float(line_split[12])
                            except:
                                pass
                            frametimes.append(frametime)
                
                np_frametimes = numpy.array(frametimes)
                avg_frametime = numpy.average(np_frametimes)
                one_percent_lows = numpy.percentile(np_frametimes, 99)
                ten_percent_lows = numpy.percentile(np_frametimes, 90)

                name_split = file[:-4].split('_')
                key = name_split[0] + '_' + name_split[1]
                category = name_split[2] + '_' + name_split[3] + '_' + name_split[4]

                if key not in data:
                    data[key] = {}
                if category not in data[key]:
                    data[key][category] = []
                data[key][category].append({
                    "avg": avg_frametime,
                    "low10": ten_percent_lows,
                    "low1": one_percent_lows
                })
                if category not in categories:
                    categories.append(category)
        break

for key in data:
    for category in data[key]:
        category_data = data[key][category]
        if len(category_data) != EXPECTED_RUNS_PER_TEST:
            print("INVALID AMOUNT OF TEST RUNS IN " + key + " - " + category + "!")
            exit(1)
        else:
            avg = 0
            one = 0
            ten = 0
            for run in category_data:
                avg += run["avg"]
                ten += run["low10"]
                one += run["low1"]
            data[key][category] = {
                "avg": avg / EXPECTED_RUNS_PER_TEST,
                "low10": ten / EXPECTED_RUNS_PER_TEST,
                "low1": one / EXPECTED_RUNS_PER_TEST,
                "avgf": 1000.0 / (avg / EXPECTED_RUNS_PER_TEST),
                "tenf": 1000.0 / (ten / EXPECTED_RUNS_PER_TEST),
                "onef": 1000.0 / (one / EXPECTED_RUNS_PER_TEST)
            }

output = open("results.csv", 'w')

for metric in ["avg", "low10", "low1", "avgf", "tenf", "onef"]:
    for category in categories:
        output.write("," + category)
    output.write("\n")
    for key in data:
        output.write(key)
        for category in categories:
            if category in data[key]:
                output.write("," + str(data[key][category][metric]))
            else:
                output.write(",")
        output.write("\n")
    output.write("\n")

output.close()